#include "graph.hpp"

Graph::Graph(NodeId nodes)
 : nodes(nodes)
{
}


void Graph::add_edge(NodeId tail, NodeId head)
{
   nodes[tail].add_outgoing(head);
   nodes[head].add_incoming(tail);
}


Graph::NodeId Graph::num_nodes() const
{
   return nodes.size();
}


Graph::EdgeId Graph::num_outgoing_edges(NodeId node_idx) const
{
   return nodes[node_idx].outgoing.size();
}


Graph::EdgeId Graph::num_incoming_edges(NodeId node_idx) const
{
   return nodes[node_idx].incoming.size();
}


Graph::NodeId Graph::outgoing_edge_head(Graph::NodeId node_idx,
                                        Graph::EdgeId edge_idx) const
{
   return nodes[node_idx].outgoing[edge_idx];
}


Graph::NodeId Graph::incoming_edge_tail(Graph::NodeId node_idx,
                                        Graph::EdgeId edge_idx) const
{
   return nodes[node_idx].incoming[edge_idx];
}


void Graph::Node::add_incoming(NodeId tail)
{
   incoming.push_back(tail);
}


void Graph::Node::add_outgoing(NodeId head)
{
   outgoing.push_back(head);
}
